<style>
/* Custom control panel styles matching user.php */
.adm_container {
    max-width: 1200px;
    margin: 20px auto;
    padding: 15px;
}

.adm_title {
    text-align: center;
    margin-bottom: 20px;
    color: var(--light);
}

.adm_card {
    background-color: #2a2a2a;
    border-radius: 8px;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    margin-bottom: 20px;
    overflow: hidden;
    transition: all 0.3s ease;
}

.adm_card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 15px rgba(0, 0, 0, 0.2);
}

.adm_card_header {
    background-color: var(--accent-tertiary);
    color: var(--light);
    padding: 15px 20px;
    border-radius: 5px 5px 0 0;
    display: flex;
    align-items: center;
    justify-content: center;
}

[data-theme="light"] .adm_card_header {
    background-color: var(--accent-tertiary);
    color: var(--light);
}

.adm_card_body {
    padding: 20px;
    background-color: #2a2a2a;
    color: var(--light);
}

[data-theme="light"] .adm_card_body {
    background-color: var(--light);
    color: var(--text-dark);
}

.adm_btn {
    display: inline-block;
    font-weight: 400;
    text-align: center;
    white-space: nowrap;
    vertical-align: middle;
    user-select: none;
    border: 1px solid transparent;
    padding: 0.5rem 1rem;
    font-size: 1rem;
    line-height: 1.5;
    border-radius: 0.25rem;
    transition: all 0.15s ease-in-out;
    cursor: pointer;
}

.adm_btn_primary {
    background-color: var(--accent-secondary);
    border-color: var(--accent-tertiary);
    color: var(--light);
}

.adm_btn_primary:hover {
    background-color: var(--accent-tertiary);
    border-color: var(--accent-secondary);
}

/* Table styling */
.table thead th {
    vertical-align: middle;
    border-bottom: 2px solid var(--border-color);
}

.table thead th i {
    margin-right: 8px;
    font-size: 16px;
}

.table tbody td {
    vertical-align: middle;
}

.form-group label i {
    margin-right: 5px;
}

.thead-dark {
    background-color: var(--primary-dark);
    color: var(--light);
}

.btn-light {
    background-color: rgba(255,255,255,0.9);
    border-color: var(--border-color);
    color: var(--text-dark);
    transition: all 0.3s ease;
}

[data-theme="light"] .btn-light {
    background-color: var(--light);
    color: var(--primary);
}

.btn-light:hover {
    background-color: #fff;
    border-color: var(--primary-light);
    color: var(--primary);
}

.thead-dark" style="background-color: var(--primary-dark);" {
    background: var(--primary-dark);
}

.table-striped tbody tr:nth-of-type(odd) {
    background-color: rgba(255,255,255,0.05);
}

.table-hover tbody tr:hover {
    background-color: rgba(255,255,255,0.1);
}

/* Estilos para iconos en la tabla */
.fa-tag { color: #FFD700 !important; }
.fa-globe { color: #00BFFF !important; }
.fa-film { color: #32CD32 !important; }
.fa-tv { color: #1E90FF !important; }
.fa-child { color: #FFD700 !important; }
.fa-line-chart { color: #FF6347 !important; }
.fa-play-circle { color: #E50914 !important; }
.fa-star { color: #FFD700 !important; }
.fa-trophy { color: #32CD32 !important; }
.fa-certificate { color: #1E90FF !important; }
.fa-cogs { color: #d0d0d0 !important; }
</style><?php 
include ('includes/header.php');

//table name
$table_name = "dns";
$page = "main.php";

//table call
$res = $db->select($table_name, '*', '', '');

//update call
@$resU = $db->select($table_name, '*', 'id = :id', '', [':id' => $_GET['update']]);

if(isset($_POST['submitU'])){
	unset($_POST['submitU']);
	$updateData = $_POST;
	$db->update($table_name, $updateData, 'id = :id',[':id' => $_GET['update']]);
	echo "<script>window.location.href='".$page."?status=1'</script>";
}

//submit new
if (isset($_POST['submit'])){
	unset($_POST['submit']);
	$db->insert($table_name, $_POST);
	$db->close();
	echo "<script>window.location.href='".$page."?status=1'</script>";
}

//delete row
if(isset($_GET['delete'])){
	$db->delete($table_name, 'id = :id',[':id' => $_GET['delete']]);
	echo "<script>window.location.href='".$page."?status=2'</script>";
}

?>
<!-- Modal de confirmación de eliminación -->
<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title">Confirm Delete</h5>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">&times;</span>
				</button>
			</div>
			<div class="modal-body">
				Do you really want to delete this item?
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
				<a class="btn btn-danger btn-ok">Delete</a>
			</div>
		</div>
	</div>
</div>

<div class="adm_container">
    <h1 class="adm_title">DNS Configuration Management</h1>
    
<?php
if (isset($_GET['create'])){
// Formulario de creación
?>
    <div class="adm_card">
        <div class="adm_card_header">
            <h4 class="mb-0"><i class="fa fa-plus-circle"></i> Add DNS Configuration</h4>
        </div>
		<div class="adm_card_body">
			<form method="post">
				<div class="row">
					<div class="col-md-6">
						<div class="form-group">
							<label for="title"><i class="fa fa-tag text-warning"></i> Title</label>
							<input class="form-control" id="title" name="title" placeholder="Title" type="text" required/>
						</div>
						<div class="form-group">
							<label for="url"><i class="fa fa-globe text-info"></i> DNS</label>
							<input class="form-control" id="url" name="url" placeholder="DNS" type="text" required/>
						</div>
						<div class="form-group">
							<label for="movies_latest"><i class="fa fa-film text-success"></i> Movies Latest ID</label>
							<input class="form-control" id="movies_latest" name="movies_latest" placeholder="Movies latest ID" type="text"/>
						</div>
						<div class="form-group">
							<label for="series_latest"><i class="fa fa-tv text-primary"></i> Series Latest ID</label>
							<input class="form-control" id="series_latest" name="series_latest" placeholder="Series latest ID" type="text"/>
						</div>
						<div class="form-group">
							<label for="tab1"><i class="fa fa-child text-warning"></i> KIDS</label>
							<input class="form-control" id="tab1" name="tab1" placeholder="TAB 1 Movies ID" type="text"/>
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group">
							<label for="tab2"><i class="fa fa-line-chart text-danger"></i> TRENDS</label>
							<input class="form-control" id="tab2" name="tab2" placeholder="TAB 2 Movies ID" type="text"/>
						</div>
						<div class="form-group">
							<label for="tab3"><i class="fa fa-play-circle text-danger"></i> NETFLIX</label>
							<input class="form-control" id="tab3" name="tab3" placeholder="TAB 3 Movies ID" type="text"/>
						</div>
						<div class="form-group">
							<label for="tab4"><i class="fa fa-star text-warning"></i> ESPECIAL</label>
							<input class="form-control" id="tab4" name="tab4" placeholder="TAB 4 Movies ID" type="text"/> 
						</div>
						<div class="form-group">
							<label for="tab5"><i class="fa fa-trophy text-success"></i> Top Movies ID</label>
							<input class="form-control" id="tab5" name="tab5" placeholder="Top Movies ID" type="text"/>
						</div>
						<div class="form-group">
							<label for="tab6"><i class="fa fa-certificate text-primary"></i> Top Series ID</label>
							<input class="form-control" id="tab6" name="tab6" placeholder="Top Series ID" type="text"/>
						</div>
					</div>
				</div>
				<div class="form-group text-center mt-3">
					<button class="btn adm_btn adm_btn_primary" name="submit" type="submit">
						<i class="fa fa-check"></i> Submit
					</button>
					<a href="<?=$page?>" class="btn btn-secondary ml-2">
						<i class="fa fa-arrow-left"></i> Back
					</a>
				</div>
			</form>
		</div>
	</div>
<?php 
} else if (isset($_GET['update'])){ 
// Formulario de actualización
?>
	<div class="card shadow-sm mb-4">
		<div class="card-header text-white style="background-color: var(--accent-tertiary);"">
			<h4 class="mb-0"><i class="fa fa-edit"></i> Edit DNS Configuration</h4>
		</div>
		<div class="adm_card_body">
			<form method="post">
				<input type="hidden" name="id" value="<?=$_GET['update'] ?>">
				<div class="row">
					<div class="col-md-6">
						<div class="form-group">
							<label for="title"><i class="fa fa-tag text-warning"></i> Title</label>
							<input class="form-control" id="title" name="title" value="<?=$resU[0]['title'] ?>" type="text" required/>
						</div>
						<div class="form-group">
							<label for="url"><i class="fa fa-globe text-info"></i> DNS</label>
							<input class="form-control" id="url" name="url" value="<?=$resU[0]['url'] ?>" type="text" required/>
						</div>
						<div class="form-group">
							<label for="movies_latest"><i class="fa fa-film text-success"></i> Movies Latest ID</label>
							<input class="form-control" id="movies_latest" name="movies_latest" value="<?=$resU[0]['movies_latest'] ?>" type="text"/>
						</div>
						<div class="form-group">
							<label for="series_latest"><i class="fa fa-tv text-primary"></i> Series Latest ID</label>
							<input class="form-control" id="series_latest" name="series_latest" value="<?=$resU[0]['series_latest'] ?>" type="text"/>
						</div>
						<div class="form-group">
							<label for="tab1"><i class="fa fa-child text-warning"></i> KIDS</label>
							<input class="form-control" id="tab1" name="tab1" value="<?=$resU[0]['tab1'] ?>" type="text"/>
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group">
							<label for="tab2"><i class="fa fa-line-chart text-danger"></i> TRENDS</label>
							<input class="form-control" id="tab2" name="tab2" value="<?=$resU[0]['tab2'] ?>" type="text"/>
						</div>
						<div class="form-group">
							<label for="tab3"><i class="fa fa-play-circle text-danger"></i> NETFLIX</label>
							<input class="form-control" id="tab3" name="tab3" value="<?=$resU[0]['tab3'] ?>" type="text"/>
						</div>
						<div class="form-group">
							<label for="tab4"><i class="fa fa-star text-warning"></i> ESPECIAL</label>
							<input class="form-control" id="tab4" name="tab4" value="<?=$resU[0]['tab4'] ?>" type="text"/>
						</div>
						<div class="form-group">
							<label for="tab5"><i class="fa fa-trophy text-success"></i> Top Movies ID</label>
							<input class="form-control" id="tab5" name="tab5" value="<?=$resU[0]['tab5'] ?>" type="text"/>
						</div>
						<div class="form-group">
							<label for="tab6"><i class="fa fa-certificate text-primary"></i> Top Series ID</label>
							<input class="form-control" id="tab6" name="tab6" value="<?=$resU[0]['tab6'] ?>" type="text"/>
						</div>
					</div>
				</div>
				<div class="form-group text-center mt-3">
					<button class="btn adm_btn adm_btn_primary" name="submitU" type="submit">
						<i class="fa fa-check"></i> Update
					</button>
					<a href="<?=$page?>" class="btn btn-secondary ml-2">
						<i class="fa fa-arrow-left"></i> Back
					</a>
				</div>
			</form>
		</div>
	</div>
<?php
} else {
// Tabla principal con todas las columnas visibles
?>
	<div class="adm_card">
		<div class="adm_card_header" style="justify-content: space-between;">
			<h4 class="mb-0"><i class="fa fa-server"></i> DNS Configurations</h4>
			<a href="./<?=$page?>?create" class="adm_btn adm_btn_primary btn-sm" style="background-color: var(--accent-secondary); color: var(--light);">
				<i class="fa fa-plus"></i> Add New
			</a>
		</div>
		<div class="adm_card_body p-0">
			<div class="table-responsive">
				<table class="table table-striped table-hover mb-0">
					<thead class="theme-header" style="background-color: var(--accent-tertiary) !important;">
<style>
.theme-header {
  background-color: var(--accent-tertiary) !important;
  color: var(--light) !important;
}

[data-theme="light"] .theme-header {
  background-color: var(--primary) !important;
  color: var(--light) !important;
}

.theme-header tr {
  background-color: inherit !important;
}

thead th {
  color: var(--light) !important;
  background-color: inherit !important;
}

thead th i {
  color: var(--light) !important;
}
</style>
						<tr>
							<th><i class="fa fa-tag text-warning"></i> Title</th>
							<th><i class="fa fa-globe text-info"></i> DNS</th>
							<th><i class="fa fa-film text-success"></i> Movies latest ID</th>
							<th><i class="fa fa-tv text-primary"></i> Series latest ID</th>
							<th><i class="fa fa-child text-warning"></i> KIDS</th>
							<th><i class="fa fa-line-chart text-danger"></i> TRENDS</th>
							<th><i class="fa fa-play-circle text-danger"></i> NETFLIX</th>
							<th><i class="fa fa-star text-warning"></i> ESPECIAL</th>
							<th><i class="fa fa-trophy text-success"></i> Top Movies ID</th>
							<th><i class="fa fa-certificate text-primary"></i> Top Series ID</th>
							<th class="text-center"><i class="fa fa-cogs text-secondary"></i> Actions</th>
						</tr>
					</thead>
					<tbody>
					<?php 
					if (count($res) > 0) {
						foreach ($res as $row) { 
					?>
						<tr>
							<td><?=$row['title']?></td>
							<td><?=$row['url']?></td>
							<td><?=$row['movies_latest']?></td>
							<td><?=$row['series_latest']?></td>
							<td><?=$row['tab1']?></td>
							<td><?=$row['tab2']?></td>
							<td><?=$row['tab3']?></td>
							<td><?=$row['tab4']?></td>
							<td><?=$row['tab5']?></td>
							<td><?=$row['tab6']?></td>
							<td class="text-center">
								<a class="btn btn-sm adm_btn adm_btn_primary" href="<?=$page?>?update=<?=$row['id']?>" title="Edit">
									<i class="fa fa-edit"></i>
								</a>
								<a class="btn btn-sm btn-danger" href="#" data-href="<?=$page?>?delete=<?=$row['id']?>" data-toggle="modal" data-target="#confirm-delete" title="Delete">
									<i class="fa fa-trash"></i>
								</a>
							</td>
						</tr>
					<?php 
						}
					} else {
					?>
						<tr>
							<td colspan="11" class="text-center py-4">No DNS configurations found. <a href="<?=$page?>?create">Create one now</a>.</td>
						</tr>
					<?php } ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
<?php } ?>
</div>

<script>
$(document).ready(function() {
    // Para pasar la URL correcta al modal de confirmación
    $('#confirm-delete').on('show.bs.modal', function(e) {
        $(this).find('.btn-ok').attr('href', $(e.relatedTarget).data('href'));
    });
});
</script>

<?php include ('includes/footer.php'); ?>
